# Vespucci 21.1 Highlights

2025-07-15 [Updated 2025-08-21]

### Android 15/API 35

As per google requirements, version 21.1 targets Android 15/API 35. Contrary to the last two years the changes this time around required a significant amount of work, not to mention a number of slightly hackish workarounds as googles own libraries are not completely compatible with the changes introduced in this Android version. 

Because of time constraints, the production version needs to be deployed on googles play store by the end of August, there are a number of remaining issues that might or might not be resolved for the release:

- the app colour scheme doesn't really work together with the inset colours, particularly in dark mode (part of the work for the migration included an overall restyling that didn't make it in to this release because of the above mentioned time constraints). 

- snackbar displayed after uploads is displayed beneath the navigation bar on older devices making it impossible to click on the displayed links.

In general if you experience any issues with menu entries, buttons etc overlapping the navigation bar or interfering with navigation gestures in a way that stops you from beable to select one or the other, please use the "Feedback" modal to open an issue, or do the same directly on [github](https://github.com/MarcusWolschon/osmeditor4android/issues). 

### Other behaviour changes 

#### Ask which "primary" key to use for _Unjoin dissimilar_

If the way you want to unjoin is tagged with more than one "primary" key a modal will display asking for you to choose the one to use for the unjoin operation.

#### Ask which role to use if multiple are possible when adding elements to a relation

Previously if multiple roles were possible when adding a new member to a relation the role would be left empty, now a modal will be displayed with a choice.

#### Add long click to delete member when editing a relation

This adds long click as a short cut for deleting a relation member in the interactive relation editing mode. 

#### Make map background configurable

The default (aka when no imagery background or similar is displayed) map background colour can be configured in the map styles.

#### Add preference to change behaviour to add images to the Mediastore

This potentially can allow an external app to delete images taken through Vespucci.

#### Remove full screen mode settings

This has been replaced by inset based code to avoid overlapping status and navigation bars.

## Miscellaneous

# Upgrading from previous versions

As a general precaution you should upload any pending changes before updating, particularly if you are upgrading from any major version that doesn't immediately precede this one. 

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
